/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  main.h
//  Main function
//
//  Matthias Ulmann, Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#ifndef MAIN_H
#define MAIN_H


// include libraries
#include <msp430F2012.h>
#include "init.h"



//******************************************************************************
// some useful macros
//******************************************************************************

// clear bit
#ifndef clear_bit
#define clear_bit(port, bit) ( port &= ~(bit) )
#endif

// set bit
#ifndef set_bit
#define set_bit(port, bit) ( port |= (bit))
#endif

// toggle bit
#ifndef toggle_bit
#define toggle_bit(port, bit) ( port ^= (bit))
#endif



//******************************************************************************
// definition of the I/O pins
//******************************************************************************

// pins for low side outputs: LS_A / LS_B
#define LS_A_pin      BIT4
#define LS_B_pin      BIT3

// function select register for LS_A / LS_B
#define LS_PSEL       P1SEL

// direction register for LS_A / LS_B
#define LS_PDIR       P1DIR

// output register for LS_A / LS_B
#define LS_POUT       P1OUT


// pins for high side outputs: HS_A_1 / HS_A_2 / HS_B_1 / HS_B_2
#define HS_A_1_pin    BIT2
#define HS_A_2_pin    BIT5
#define HS_B_1_pin    BIT1
#define HS_B_2_pin    BIT6

// function select register for HS_A_1 / HS_A_2 / HS_B_1 / HS_B_2
#define HS_PSEL       P1SEL

// direction register for HS_A_1 / HS_A_2 / HS_B_1 / HS_B_2
#define HS_PDIR       P1DIR

// output register for HS_A_1 / HS_A_2 / HS_B_1 / HS_B_2
#define HS_POUT       P1OUT


// pins for digital inputs: NEUTRAL / LINE
#define NEUTRAL_pin   BIT6
#define LINE_pin      BIT7

// function select register for NEUTRAL / LINE
#define DIG_IN_PSEL   P2SEL

// direction register for NEUTRAL / LINE
#define DIG_IN_PDIR   P2DIR

// output register for NEUTRAL / LINE
#define DIG_IN_POUT   P2OUT

// input register for NEUTRAL / LINE
#define DIG_IN_PIN    P2IN


// pin for analog input: CURRENT
#define CURRENT_pin   BIT0

// function select register for CURRENT
#define CURRENT_PSEL  P1SEL

// direction register for CURRENT
#define CURRENT_PDIR  P1DIR

// output register for CURRENT
#define CURRENT_POUT  P1OUT



//******************************************************************************
// simple control macros for the outputs
//******************************************************************************

// switch low side outputs on/off
#define LS_A_on         clear_bit(LS_POUT, LS_A_pin)
#define LS_B_on         clear_bit(LS_POUT, LS_B_pin)
#define LS_A_off        set_bit(LS_POUT, LS_A_pin)
#define LS_B_off        set_bit(LS_POUT, LS_B_pin)

// toggle low side outputs
#define LS_L_toggle     toggle_bit(LS_POUT, LS_A_pin)
#define LS_R_toggle     toggle_bit(LS_POUT, LS_B_pin)


// enable/disable PWM outputs
#define HS_A_1_on         set_bit(HS_PSEL, HS_A_1_pin)
#define HS_A_2_on         set_bit(HS_PSEL, HS_A_2_pin)
#define HS_A_1_off        clear_bit(HS_PSEL, HS_A_1_pin)
#define HS_A_2_off        clear_bit(HS_PSEL, HS_A_2_pin)
#define HS_B_1_on         set_bit(HS_PSEL, HS_B_1_pin)
#define HS_B_2_on         set_bit(HS_PSEL, HS_B_2_pin)
#define HS_B_1_off        clear_bit(HS_PSEL, HS_B_1_pin)
#define HS_B_2_off        clear_bit(HS_PSEL, HS_B_2_pin)


// read digital inputs
#define NEUTRAL_high      ( DIG_IN_PIN & NEUTRAL_pin )
#define LINE_high         ( DIG_IN_PIN & LINE_pin )



#endif
